#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<float.h>

//Racunanje euklidske vrednosti
double racunanje_euklidske_vrednosti(double x1, double y1, double x2, double y2)
{
    return sqrt((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2));
}

//Kreiranje matrice postojecih veza
int **napraviMatricuVeza(int n)
{
    int **matrica = malloc (n * sizeof(int*));
    for (int i = 0; i<n; i++)
    {
        matrica[i] = calloc(n, sizeof(int));
    }

    return matrica;
}

//Oslobadjanje matrice
void oslobodiMatricu(int **matrica, int n)
{
    for(int i = 0; i<n; i++)
        free(matrica[i]);
    free(matrica);
}

//Ucitavanje postojecih veza
void ucitajVeze(int **matrica, int k)
{
    for(int i = 0; i<k; i++)
    {
        int a, b;
        scanf("%d %d", &a, &b);
        matrica[a][b]=1;
        matrica[b][a]=1;
    }
}

//Pronalazi sledeci cvor za Prim-a
int pronadjiMinCvor(double *min_udaljenost, int *uStablu, int n)
{
    double min = DBL_MAX;
    int indeks = -1;

    for(int i = 0; i<n; i++)
    {
        if(!uStablu[i] && min_udaljenost[i]<min)
        {
            min = min_udaljenost[i];
            indeks = i;
        }
    }
    return indeks;
}


// Primov algoritam
double prim(int n, double *x, double *y, int **postoji_veza)
{
    int *uStablu = calloc(n, sizeof(int));
    double *min_udaljenost = malloc(n * sizeof(double));

    for(int i = 0; i<n; i++)
    {
        min_udaljenost[i] = DBL_MAX;
    }
    
    min_udaljenost[0]=0.0;

    double ukupna_duzina = 0.0;

    for(int brojac = 0; brojac<n; brojac++)
    {
        int izabrani = pronadjiMinCvor(min_udaljenost, uStablu, n);
        uStablu[izabrani] = 1;
        ukupna_duzina += min_udaljenost[izabrani];

        for(int i = 0; i<n; i++)
        {
            if(!uStablu[i])
            {
                double cena;
                if(postoji_veza[izabrani][i])
                    cena = 0.0;
                else{
                    cena =racunanje_euklidske_vrednosti(x[izabrani], y[izabrani], x[i], y[i]);
                }
                if(cena < min_udaljenost[i])
                    min_udaljenost[i] = cena;
            }
        }
    }

    free(uStablu);
    free(min_udaljenost);

    return ukupna_duzina;
}

//Main
int main(){

    int n;
    scanf("%d", &n);

    double *x = malloc(n * sizeof(double));
    double *y = malloc(n * sizeof(double));

    for(int i = 0; i<n; i++)
    {
        scanf("%lf %lf", &x[i], &y[i]);
    }

    int k;
    scanf("%d", &k);
    int **postoji_veza = napraviMatricuVeza(n);

    ucitajVeze(postoji_veza,k);

    double rezultat = prim(n, x, y, postoji_veza);

    printf("\nRezultat: %.2lf\n", rezultat);

    oslobodiMatricu(postoji_veza, n);
    free(x);
    free(y);

    return 0;

}