#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#define INF 100000000
#define NILL -1
#define TRUE 1
#define FALSE 0

int nadjiMin(float *d, int *obidjen, int n)
{
    int min = INF;
    int minCvor = NILL;

    for(int u = 0;u<n;u++)
    {
        if(d[u]<min && obidjen[u] == FALSE)
        {
            min = d[u];
            minCvor = u;
        }
    }
    return minCvor;
}

void relax(float **graf, float *d, int *pret, int u, int v)
{
    if(d[v]>graf[u][v])
    {
        d[v] = graf[u][v];
        pret[v] = u;
    }
}

float prim(float **graf, float *d, int *obidjen, int *pret, int n, int s)
{
    d[s] = 0;
    int ukupno = 0;
    int u;
    for(int i = 0;i<n;i++)
    {
        u = nadjiMin(d, obidjen, n);
        if(u == NILL) break;
        obidjen[u] = TRUE;
        ukupno+= d[u];
        for(int v = 0;v<n;v++)
        {
            if(graf[u][v]!=INF && obidjen[v] == FALSE)
            {
                relax(graf, d, pret, u ,v);
            }
        }
    }
    return ukupno;
}

int main()
{
    int n;
    scanf("%d", &n);

    float *Xi = (float *)malloc(sizeof(float)*n);
    float *Yi = (float *)malloc(sizeof(float)*n);

    for(int i = 0;i<n;i++)
    {
        int x,y;
        scanf("%d %d", &x, &y);
        Xi[i] = x;
        Yi[i] = y;
    }

    float **graf = (float **)malloc(sizeof(float*)*n);
    int *obidjen = (int *)malloc(sizeof(int)*n);
    int *pret = (int*)malloc(sizeof(int)*n);
    float *d = (float *)malloc(sizeof(float)*n);

    for(int i = 0;i<n;i++)
    {
        graf[i] = (float *)malloc(sizeof(float)*n);
        obidjen[i] = FALSE;
        pret[i] = NILL;
        d[i] = INF; 
        for(int j = 0;j<n;j++)
        {
            graf[i][j] = INF;
        }
    }

    for(int i = 0;i<n;i++)
    {
        for(int j = 0;j<n;j++)
        {
            if(i == j) continue;
            
            float dx = Xi[j] - Xi[i];
            float dy = Yi[j] - Yi[i];

            graf[i][j] = sqrt(dx*dx + dy*dy);
            graf[j][i] = sqrt(dx*dx + dy*dy);
 
        }
    }

    int k;
    scanf("%d", &k);

    for(int i = 0;i<k;i++)
    {
        int x,y;
        scanf("%d %d", &x, &y);
        graf[x][y] = 0;
        graf[y][x] = 0;
    }

    

    float ukupno = prim(graf,d, obidjen, pret,n,0);
    

    printf("%.2f\n", ukupno);

}