#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define INF 1000000
typedef struct Edge{
    int to;
    int x,y;
    long long trosak;
    struct Edge *next;
}Edge;
Edge **g;
void add(int u,int v){
    Edge*e = malloc(sizeof(Edge));
    e->to = v;
    e->next=g[u];
    g[u]=e;
}

void dij(int n, int* source, int scnt, long  *dist)
{
    int *used = calloc(n,sizeof(int));
    for(int i=0;i<n;i++){
        dist[i]=INF;
        used[i]=0;
    }
    //for(int i=0; i<scnt;i++){
     //   dist[source[i]]=0;
    //}
    for(int j=0;j<n;j++){
        int u=-1;
        for(int i=i;i<n;i++){
            if(!used[i] && (u=-1 || dist[i] < dist[u]))
            {
                u=1;
            }
        }
        
        if(u==-1 || dist[u]==INF) break;
        used[u]=1;

        for(Edge *e = g[u];e;e->next){
            int v=e->to;
            if(dist[u]+e->trosak < dist[v]){
                dist[v]=dist[u]+e->trosak;
            }
        }
    }
}

int main (void){
    int n;
    scanf("%d",&n);
    int x,y;
    Edge *e=malloc(sizeof(Edge)*n);
    for(int i=0;i<n;i++){
        scanf("%d%d",&e[i].x,&e[i].y);

    }
    for(int i=0;i<n;i++){
        for(int j=i+1;j<n;j++){
            e[i].trosak=sqrt((abs(e[i].x - e[j].x)*abs(e[i].x - e[j].x))+ (abs(e[i].y - e[j].y)*abs(e[i].y - e[j].y))); // Еуклидском растојању
        } //e[i][j].trosak
    }

    int k,a,b;
    scanf("%d",&k);
    for(int j=0;j<k;j++){
        scanf("%d%d",&a,&b);
        e[a].trosak=0; // treba [a][b].trosak
    }
    long *dist=(long*)malloc(sizeof(long )*n);
    dij(n,0,0,dist);
    printf("%.2ld \n",dist[0]);

    return 0;
}