#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<stdbool.h>

#define NEDEFINISANO -1
#define TRUE 1
#define FALSE 0

typedef struct kordinate{
    double x;
    double y;
}kordinate; 
double rastojanje(double x1, double x2, double y1, double y2) {
    double X = x2 - x1;
    double Y = y2 - y1;
    return sqrt(X*X + Y*Y);
}
bool isMin(double i, double j) {
    if(i == NEDEFINISANO) return false;
    if (j == NEDEFINISANO) return true;

    return i < j;
}
int findMin(double *d,int *obidjen, int n) {
    double min = NEDEFINISANO;
    int ind = NEDEFINISANO;
    for (int i = 0; i < n; i++) {
        if (obidjen[i] == FALSE && isMin(d[i],min)) {
            min = d[i];
            ind = i;
        }
    }
    return ind;
}
void primov(double **graf, double *d, int *obidjen, int n) {
    for (int i = 0; i < n; i++) {
        int u = findMin(d,obidjen,n);
        if(u == NEDEFINISANO) break;
        obidjen[u] = TRUE;
        for (int v = 0; v < n;v++) {
            if (obidjen[v] == FALSE && graf[u][v] != NEDEFINISANO) {
                if(isMin(graf[u][v], d[v])) {
                    d[v] = graf[u][v];
        
                }
            }
        }
    }
}
int main() {
    int n;
    scanf("%d",&n);
    double **graf = (double **) malloc(n * sizeof (double *));
    double *d = (double *) malloc(n * sizeof (double *));
    int *obidjen = (int *) malloc(n * sizeof(int *));
    kordinate k[n]; 

    for (int i = 0; i < n; i++) {
        graf[i] = (double *) malloc(n * sizeof(double));
        d[i] = NEDEFINISANO;
        obidjen[i] = FALSE;
        for (int j = 0; j < n; j++) {
            graf[i][j] = NEDEFINISANO;
        }
    }
    for (int i = 0; i < n; i++) {
        double x,y;
        scanf("%lf%lf",&x,&y);
        k[i].x = x;
        k[i].y = y;
    }
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            if (i != j) {
                graf[i][j] = rastojanje(k[i].x,k[j].x,k[i].y,k[j].y);
            }
        }
    }
    int broj; // koliko ih vec povezano bilo direktnu vezu
    scanf("%d",&broj);
    for (int i = 0; i < broj; i++) {
        int a,b;
        scanf("%d%d",&a,&b);
        graf[a][b] = graf[b][a] = 0; // znaci nema proska
    }
    d[0] = 0; // neka on bude pocetni. nije bitno
    primov(graf,d,obidjen,n);

    double ukupanTrosak = 0.0;
    for (int i = 0; i < n; i++) {
        if(d[i] != NEDEFINISANO)
        {
            ukupanTrosak += d[i];
        }
    }
    printf("%.2lf",ukupanTrosak);

}