#include <stdio.h>
#include <stdlib.h>

typedef struct cvor
{
    int vrednost;
    struct cvor *l,*d;
}cvor;

cvor *novi(int vrednost)
{
    cvor *n=(cvor *)malloc(sizeof(cvor));
    n->vrednost = vrednost;
    n->l=n->d=NULL;
    return n;
}

void dodajCvor(cvor *koren,int vrednost)
{
    if(vrednost<koren->vrednost)
    {
        if(!koren->l)
            koren->l=novi(vrednost);
        else
            dodajCvor(koren->l,vrednost);
    }
    else
    {
        if(!koren->d)
            koren->d=novi(vrednost);
        else
            dodajCvor(koren->d,vrednost);
    }
}

cvor *napraviStablo(int n)
{
    cvor *koren;
    int x;
    printf("\nUnesi koren stabla > ");
    scanf("%d",&x);
    koren=novi(x);
    for(int i=0;i<n-1;i++)
    {
        printf("\nUnesi cvor > ");
        scanf("%d",&x);
        dodajCvor(koren,x);
    }
    return koren;
}

void razmak(int nivo)
{
    for(int i=0;i<nivo;i++) putchar('\t');
}
void prikaz(cvor *koren,int nivo)
{
    if(!koren)
    {
        razmak(nivo);
        puts("~");
    }
    else
    {
        prikaz(koren->d,nivo+1);
        razmak(nivo);
        printf("%d\n",koren->vrednost);
        prikaz(koren->l,nivo+1);
    }
}

void ispis(cvor *koren)
{
    if(!koren)
        return;

    ispis(koren->l);
    printf("%d\n",koren->vrednost);
    ispis(koren->d);
}

int suma(cvor *koren)
{
    if(!koren)
        return 0;

    return koren->vrednost+suma(koren->l)+suma(koren->d);
}

void transformisi(cvor *koren)
{
    if(!koren)
        return;
    

    int vrednost=koren->vrednost;
    int s=0;

    if(koren->l)
    {
        
        s=suma(koren->l);
        koren->vrednost=s;
    }
    
    if(koren->d)
        koren->d->vrednost=s+vrednost;

    
    transformisi(koren->l);
    transformisi(koren->d);
    
}

int main()
{
    printf("\nUnesi broj cvorova: ");
    int n;scanf("%d",&n);
    cvor *koren = napraviStablo(n);
    prikaz(koren,0);
    transformisi(koren);
    printf("\n------------------\n");
    prikaz(koren,0);

}