#include <stdio.h>
#include <stdlib.h>

#define allocate(type, n) ((type*) malloc ((n) * sizeof(type)))

void allocation_error()
{
    printf("Allocation error\n");
    exit(1);
}

typedef struct TreeNode
{
    int val;
    struct TreeNode *left, *right;
} Node;

Node *newNode(int val)
{
    Node *new = allocate(Node, 1);
    if(!new) allocation_error();
    new->val = val;
    new->left = new->right = NULL;
    return new;
}

void insert(Node **root, Node *new)
{
    if(!*root)
    {
        *root = new;
        return;
    }

    if(new->val < (*root)->val) insert(&(*root)->left, new);
    else insert(&(*root)->right, new);
}

Node *formTree()
{
    int n;
    scanf("%d", &n);

    Node *root = NULL;

    for(int i = 0; i < n; i++)
    {
        int val;
        scanf("%d", &val);
        insert(&root, newNode(val));
    }

    return root;
}

void transform_(Node *root, int *sum)
{
    if(!root) return;

    transform_(root->left, sum);

    int prev = root->val;
    root->val = *sum;
    (*sum) += prev;

    transform_(root->right, sum);
}

void transform(Node *root)
{
    int sum = 0;
    transform_(root, &sum);
}

void preorder(Node *root)
{
    if(!root) return;

    printf("%d\n", root->val);
    preorder(root->left);
    preorder(root->right);
}

void freeTree(Node *root)
{
    if(!root) return;

    freeTree(root->left);
    freeTree(root->right);
    free(root);
}

int main()
{
    Node *root = formTree();

    transform(root);

    preorder(root);

    freeTree(root);

    return 0;
}