#include <stdio.h>
#include <stdlib.h>

typedef struct cvor{
    int br, balans;
    struct cvor *l, *d;
}Cvor;

Cvor *noviCvor(int br){
    Cvor *novi = (Cvor*)malloc(sizeof(Cvor));
    novi->l = novi->d = NULL;
    novi->br = br;
    novi->balans = 0;

    return novi;
}

int max(int x, int y){
    return x > y ? x : y;
}

int dubina(Cvor *koren){
    if(!koren) return 0;
    return 1 + max(dubina(koren->l), dubina(koren->d));
}

void levaRotacija(Cvor **koren){
    Cvor *poml = *koren;
    Cvor *pomd = poml->d;

    poml->d = pomd->l;
    pomd->l = poml;

    *koren = pomd;

    poml->balans = dubina(poml->d) - dubina(poml->l);
    pomd->balans = dubina(pomd->d) - dubina(pomd->l); 
}

void desnaRotacija(Cvor **koren){
    Cvor *pomd = *koren;
    Cvor *poml = pomd->l;

    pomd->l = poml->d;
    poml->d = pomd;

    *koren = poml;

    poml->balans = dubina(poml->d) - dubina(poml->l);
    pomd->balans = dubina(pomd->d) - dubina(pomd->l); 
}

int dodaj(Cvor **koren, int br){
    Cvor *t = *koren;

    if(!t){
        t = noviCvor(br);
        *koren = t;
        return 1;
    }

    int inc;
    if(br < t->br) inc = -dodaj(&t->l, br);
    else inc = dodaj(&t->d, br);

    t->balans += inc;

    if(inc && t->balans){
        if(t->balans < -1){
            if(t->l->balans < 0) desnaRotacija(&t);
            else{
                levaRotacija(&t->l);
                desnaRotacija(&t);
            }
        }
        else if(t->balans > 1){
            if(t->d->balans > 0) levaRotacija(&t);
            else{
                desnaRotacija(&t->d);
                levaRotacija(&t);
            }
        }
        else return 1;
    }

    *koren = t;
    return 0;
}

void ispis(Cvor *koren){
    if(!koren) return;

    printf("%d\n", koren->br);
    ispis(koren->l);
    ispis(koren->d);
}

void sumaNajdubljih(Cvor *koren, int maxDubina, int t, int *suma){
    if(!koren) return;

    if(t == maxDubina) *suma += koren->br;

    sumaNajdubljih(koren->l, maxDubina, t + 1, suma);
    sumaNajdubljih(koren->d, maxDubina, t + 1, suma);
}

int main(){
    Cvor *koren = NULL;

    while(1){
        int br;
        scanf("%d", &br);
        if(br == 0) break;
        dodaj(&koren, br);
    }

    //ispis(koren);

    int suma = 0;
    int dub = dubina(koren);
    //printf("%d\n", dub);
    sumaNajdubljih(koren, dub, 1, &suma);
    printf("%d\n", suma);

    return 0;
}