#include <stdio.h>
#include <stdlib.h>

typedef struct cvor{
    int vrednost;
    struct cvor* levi;
    struct cvor* desni;
} cvor;

cvor* napraviCvor(int vrednost){
    cvor* novi = (cvor*)malloc(sizeof(cvor));
    novi->vrednost = vrednost;
    novi->levi = NULL;
    novi->desni = NULL;

    return novi;
}

cvor* napraviStablo(){
    cvor* pocetak = NULL;
    int n;
    printf("Unesite n cvorova: ");
    scanf("%d", &n);
    for(int i=0 ; i<n ; i++){
        int cvr;
        printf("Unesite cvor: ");
        scanf("%d", &cvr);
        if(pocetak==NULL){
            pocetak = napraviCvor(cvr);
            continue;
        }

        cvor* temp = pocetak;
        while(temp){
            if(temp->vrednost>cvr){
                if(temp->levi!=NULL){
                    temp = temp->levi;
                }else{break;}
            }else{
                if(temp->desni!=NULL){
                    temp = temp->desni;
                }else{break;}
            }
        }

        if(temp->vrednost<cvr){
            temp->desni = napraviCvor(cvr);
        }else{
            temp->levi = napraviCvor(cvr);
        }

    }

    return pocetak;
}

int suma(cvor* stablo, int gornja){
    int sum = 0;
    if(stablo==NULL) return 0;

    if(stablo->vrednost<gornja){
        sum += stablo->vrednost;
    }

    sum += suma(stablo->levi, gornja);
    sum += suma(stablo->desni, gornja);

    return sum;
}

void transformisi(cvor* stablo, int* niz){ //ako stavim cvor* s koji pokazuje takodje na stablo, print mi vraca dobre sume za ponaosob cvorove
    if(stablo==NULL){
        return;
    }
    
    //printf("%d - %d\n",stablo->vrednost, suma(stablo, stablo->vrednost));

    if(stablo->levi || stablo->desni){
        stablo->vrednost = suma(stablo,stablo->vrednost);
    }

    transformisi(stablo->desni, niz);
    transformisi(stablo->levi, niz);
}

void napuniNiz(cvor* stablo, int* niz){
    int static i=0;
    if(stablo==NULL) return;
    i++;
    niz[i] = suma(stablo,stablo->vrednost);

    napuniNiz(stablo->levi, niz);
    napuniNiz(stablo->desni, niz);
}




void razmak(int nivo){
    for(int i=0 ; i<nivo ; i++){
        putchar('\t');
    }
}

void stampa(cvor* stablo, int nivo){
    if(stablo==NULL){
        razmak(nivo);
        puts("null");
    }else{
        stampa(stablo->desni, nivo+1);
        razmak(nivo);
        printf("%d\n", stablo->vrednost);
        stampa(stablo->levi, nivo+1);
    }
}

int main(){
    cvor* stablo = napraviStablo();
    stampa(stablo, 0);
    
    int suma1 = suma(stablo,10);
    int suma2 = suma(stablo,5);
    int suma3 = suma(stablo,12);
    int suma4 = suma(stablo,3);
    int suma5 = suma(stablo,7);
    int suma6 = suma(stablo,14);
    printf("10: %d\n5: %d\n12: %d\n3: %d\n7: %d\n14:%d\n",suma1,suma2,suma3,suma4,suma5,suma6);
    
 
    

    int* niz = (int*)malloc(100*sizeof(int));
    for(int i=0 ; i<6 ; i++){
        printf("%d", niz[i]);
    }
    
    transformisi(stablo, niz);

    printf("\n");
    stampa(stablo, 0);
}