#include<stdio.h>
#include<stdlib.h>

typedef struct cvor{
    int br;
    int balans;
    struct cvor *l, *d;
}cvor;

int max(int x, int y){
    return x > y ? x : y;
}

int dubina(cvor *koren){

    if(!koren)
      return 0;

    return 1 + max( dubina(koren->l), dubina(koren->d));
}

void azurirajBalans(cvor *t){

    if(!t)
      return;

    t-> balans  = dubina(t->d) - dubina(t->l);
}

void lRotacija(cvor **t){
    cvor *poml = *t;
    cvor *pomd = poml -> d;

    poml -> d = pomd ->l;
    pomd ->l = poml;
    *t = pomd;

    azurirajBalans(poml);
    azurirajBalans(pomd);
}

void dRotacija(cvor **t){
    cvor *pomd = *t;
    cvor *poml = pomd -> l;

    pomd -> l = poml ->d;
    poml -> d = pomd;
    *t = poml;

    azurirajBalans(poml);
    azurirajBalans(pomd);
}

void balansiraj(cvor **t){

    if(!*t)
      return;

    if( (*t)->balans < -1){

        if( (*t)->l && (*t)->l->balans < 0){
            dRotacija(t);

        }else{
            lRotacija(&(*t)->l);
            dRotacija(t);
        }
    }else if( (*t)->balans > 1){

        if( (*t)->d && (*t)->d->balans > 0){
            lRotacija(t);
        }else{
            dRotacija(&(*t)->d);
            lRotacija(t);
        }
    }
}

cvor *novi(int x){

    cvor *novi = (cvor*)malloc(sizeof(cvor));
    novi -> br = x;
    novi -> balans = 0;
    novi->l = novi -> d = NULL;

    return novi;
}

cvor *dodaj(cvor *koren, int x){

    if(koren == NULL)
      return novi(x);

    if(koren->br > x){
      koren-> l = dodaj(koren->l, x);
      azurirajBalans(koren);
      balansiraj(&koren);
      azurirajBalans(koren);
    }else if(koren->br < x){
      koren-> d = dodaj(koren->d, x);
      azurirajBalans(koren);
      balansiraj(&koren);
      azurirajBalans(koren);
    }

    azurirajBalans(koren);
    balansiraj(&koren);
    azurirajBalans(koren); 

    return koren;
}


void ispisi(cvor *koren){

    if(koren == NULL)
      return;

    printf("%d\n", koren->br);
    ispisi(koren->l);
    ispisi(koren->d);
}

void razmak(char c, int nivo){

    while(nivo--){
        putchar('\t');
    }
}

void vizuelniPrikaz(cvor *koren , int nivo){

    if(!koren){
        razmak('\t', nivo);
        puts("~");
    }else{
        vizuelniPrikaz(koren->d, nivo + 1);
        razmak('\t', nivo);
        printf("%d\n", koren->br);
        vizuelniPrikaz(koren->l, nivo + 1);
    }
}

long long suma(cvor *koren,int nivo, int poslednji_nivo){

    if(!koren)
      return 0;


    if(koren-> l == NULL && koren->d == NULL && nivo == poslednji_nivo)
       return koren-> br + suma(koren->l, nivo+1, poslednji_nivo) + suma(koren->d, nivo + 1, poslednji_nivo);

    return suma(koren->l, nivo+1, poslednji_nivo) + suma(koren->d, nivo + 1, poslednji_nivo);
     //suma(koren->l, nivo + 1, poslednji_nivo, suma_listova);
    // suma(koren->d, nivo + 1, poslednji_nivo, suma_listova);

    
}



int main(){

    int n;
    scanf("%d", &n);
    cvor *koren = NULL;
    koren = dodaj(koren, n);

    while(n){

        scanf("%d", &n);

         if(n == 0)
         break;

        koren = dodaj(koren, n);


    }

  //  ispisi(koren);

  int poslednji_nivo = dubina(koren);

  //printf("%d\n", poslednji_nivo);

  long long suma_listova = suma(koren, 1, poslednji_nivo);
  

  printf("%lld\n", suma_listova);

 // vizuelniPrikaz(koren, 0);
 
   // ispisi(koren);
    return 0;
}
