#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define null NULL

typedef struct cvor
{
    int vrednost;
    struct cvor *levi,*desni;
}cvor;

cvor *noviCvor(int vrednost)
{
    cvor *novi=(cvor*)malloc(sizeof(cvor));
    novi->vrednost=vrednost;
    novi->levi=novi->desni=null;
    return novi;
}

void dodaj(cvor **koren,int vrednost)
{
    if(!(*koren))
    {
        *koren=noviCvor(vrednost);
        return;
    }

    cvor *t=*koren;

    if(vrednost<t->vrednost)
        dodaj(&t->levi,vrednost);
    else
        dodaj(&t->desni,vrednost);
}

void razmak(int n)
{
    for(int i=0;i<n;i++)
    {
        putchar('\t');
    }
}

void vizuelniPrikaz(cvor *koren,int nivo)
{
    if(!koren) 
    {
        razmak(nivo);
        puts("~");
    }
    else
    {
        vizuelniPrikaz(koren->desni,nivo+1);
        razmak(nivo);
        printf("%d\n",koren->vrednost);
        vizuelniPrikaz(koren->levi,nivo+1);
    }
}

void printTree(cvor *koren)
{
    if(!koren)return;
    printf("%d\n",koren->vrednost);
    printTree(koren->levi);
    printTree(koren->desni);
}

void zameniManjim(cvor *koren,int *suma)
{
    if(!koren) return;

    zameniManjim(koren->levi,suma);
    int temp=koren->vrednost;
    koren->vrednost=*suma;
    *suma+=temp;
    if(koren->desni && koren->desni->vrednost>temp)
    {
        zameniManjim(koren->desni,suma);
    }
    else
    {
        return;
    }
}

int main()
{
    int n;
    scanf("%d",&n);
    cvor *koren=null;

    int x;
    for(int i=0;i<n;i++)
    {
        scanf("%d",&x);
        dodaj(&koren,x);
    }
    int suma=0;
    zameniManjim(koren,&suma);
    printTree(koren);


}
