#include<stdio.h>
#include<stdlib.h>

typedef struct Node{
    int val;
    struct Node *l, *r;
}Node;

Node *insert(Node *root, int val){
    if(root==NULL){
        Node *new=(Node *)malloc(sizeof(Node));
        new->val=val;
        new->l=new->r=NULL;

        return new;
    }

    if(val<root->val){
        root->l=insert(root->l, val);
    }else{
        root->r=insert(root->r, val);
    }

    return root;
}

void Transformacija(Node *root, int *sum, int *preth){
    if(root==NULL){
        return;
    }

    Transformacija(root->l, sum, preth);
    *preth=*sum;
    *sum+=root->val;
    root->val=*preth;
    Transformacija(root->r, sum, preth);
}

void razmak(char c, int n){
    for(int i=0; i<n; i++){
        putchar(c);
    }
}

void vizuelniPrikaz(Node *n, int nivo){
    if(n==NULL){
        razmak('\t', nivo);
        puts("~");
    }else{
        vizuelniPrikaz(n->r, nivo+1);
        razmak('\t', nivo);
        printf("%d\n", n->val);
        vizuelniPrikaz(n->l, nivo+1);
    }
}

void print(Node *root){
    if(root==NULL){
        return;
    }

    printf("%d\n", root->val);
    print(root->l);
    print(root->r);
}

int main(){
    int n;
    scanf("%d", &n);
    Node *root=NULL;

    int x;
    for(int i=0; i<n; i++){
        scanf("%d", &x);
        root=insert(root, x);
    }

    //vizuelniPrikaz(root, 0);
    //printf("----------------------------------\n");
    int sum=0;
    int preth=0;
    Transformacija(root, &sum, &preth);
    //vizuelniPrikaz(root, 0);
    print(root);

    return 0;
}