#include<stdio.h>
#include<stdlib.h>
#include<string.h>

typedef struct Node{
    int val;
    int height;
    struct Node *l, *r;
}Node;


Node *create(int val){
    Node *new=(Node*)malloc(sizeof(Node));
    new->val=val;
    new->height=1;
    new->l=new->r=NULL;

    return new;
}

int compare(int val, Node *n){
    return val - n->val;
}

int max(int a, int b){
    if(a>b){
        return a;
    }else{
        return b;
    }
}

int height(Node *n){
    if(n==NULL){
        return 0;
    }

    return n->height;
}

int balance(Node *n){
    if(n!=NULL){
        return height(n->l) - height(n->r);
    }

    return 0;
}

Node *leftRotate(Node *x){
    Node *y = x->r;
    Node *y2 = y->l;

    y->l=x;
    x->r=y2;

    x->height=max(height(x->l), height(x->r))+1;
    y->height=max(height(y->l), height(y->r))+1;

    return y;
}

Node *rightRotate(Node *y){
    Node *x = y->l;
    Node *x2 = x->r;

    x->r = y;
    y->l = x2;

    x->height=max(height(x->l), height(x->r))+1;
    y->height=max(height(y->l), height(y->r))+1;

    return x;

}

Node *insert(Node *n, int val){
    if(n==NULL){
        return create(val);
    }
    
    if(compare(val, n)<0){
        n->l=insert(n->l, val);
    }else{
        n->r=insert(n->r, val);
    }

    n->height=max(height(n->l), height(n->r))+1;
    int b=balance(n);

    if(b>1 && compare(val, n->l)<0){
        return rightRotate(n);
    }

    if(b>1 && compare(val, n->l)>0){
        n->l=leftRotate(n->l);
        return rightRotate(n);
    }

    if(b<-1 && compare(val, n->r)>0){
        return leftRotate(n);
    }

    if(b<-1 && compare(val, n->r)<0){
        n->r=rightRotate(n->r);
        return leftRotate(n);
    }

    return n;
}

int maxDubina(Node *n){
    if(n==NULL){
        return 0;
    }

    return max(maxDubina(n->l), maxDubina(n->r))+1;
}

void sumaListovaNaPoslednjemNivou(Node *n, int max, int deep, int *sum){
    if(n==NULL){
        return;
    }

    if(!n->l && !n->r && deep==max){
        *sum+=n->val;
    }

    sumaListovaNaPoslednjemNivou(n->l, max, deep+1, sum);
    sumaListovaNaPoslednjemNivou(n->r, max, deep+1, sum);
}

void razmak(char c, int n){
    for(int i=0; i<n; i++){
        putchar(c);
    }
}

void vizuelniPrikaz(Node *n, int nivo){
    if(n==NULL){
        razmak('\t', nivo);
        puts("~");
    }else{
        vizuelniPrikaz(n->r, nivo+1);
        razmak('\t', nivo);
        printf("%d\n", n->val);
        vizuelniPrikaz(n->l, nivo+1);
    }
}

int main(){
    Node *root=NULL;

    while(1){
        int cvor;
        scanf("%d", &cvor);

        if(cvor==0){
            break;
        }

        root=insert(root, cvor);
    }

    //vizuelniPrikaz(root, 0);


    int maxD=maxDubina(root);
    int sum=0;                                                                                                                        
    sumaListovaNaPoslednjemNivou(root, maxD, 1, &sum);
    printf("%d\n", sum);

    return 0;
}