#include<stdio.h>
#include<stdlib.h>

typedef struct cvor{
    int broj;
    int zbir;
    int balans;
    struct cvor *levi, *desni;
}Cvor;

int zbirC(int broj){
    int zbir = 0;
    while(broj){
        zbir+= broj%10;
        broj = broj/10;
    }
    return zbir;
}

int dubina(Cvor *koren){
    if(koren == NULL) return 0;
    int levi = dubina(koren->levi);
    int desni = dubina(koren->desni);
    return (levi > desni ? levi : desni ) + 1;
}

void lrotacija(Cvor **koren){
    // printf("Lrot\n");
    Cvor *poml,*pomd;
    poml = *koren;
    pomd = poml->desni;
    poml->desni = pomd->levi;
    pomd->levi = poml;
    
    pomd->balans = dubina(pomd->desni) - dubina(pomd->levi);
    poml->balans = dubina(poml->desni) - dubina(poml->levi);
    *koren = pomd;
}

void drotacija(Cvor **koren){
    // printf("Rrot\n");
    Cvor *poml,*pomd;
    pomd = *koren;
    poml = pomd->levi;
    pomd->levi = poml->desni;
    poml->desni = pomd;
    
    pomd->balans = dubina(pomd->desni) - dubina(pomd->levi);
    poml->balans = dubina(poml->desni) - dubina(poml->levi);
    *koren = poml;
}

int dodaj(Cvor **koren, int vrednost){
    Cvor *t = *koren;
    int rezultat = 0;
    int inkrement = 0;
    Cvor *novi = (Cvor*)malloc(sizeof(Cvor));
    novi->broj = vrednost;
    novi->zbir = zbirC(vrednost);
    novi->balans = 0;
    novi->levi = NULL;
    novi->desni = NULL; 
    int c = zbirC(vrednost);

    if(t == NULL){
        t = novi;
        rezultat = 1;
    }
    else{
        if(c < t->zbir ) inkrement = -dodaj(&(t->levi), vrednost);
        else inkrement = dodaj(&(t->desni), vrednost);
        t->balans += inkrement;
        if(inkrement != 0 && t->balans != 0){
            if(t->balans < -1){
                if(t->levi && t->levi->balans <  0) drotacija(&(t->levi));
                else { lrotacija(&(t->levi)); drotacija(&t); }
            }
            else if(t->balans > 1){
                if(t->desni && t->desni->balans >  0) lrotacija(&(t->desni));
                else { drotacija(&(t->desni)); lrotacija(&t); }
            }
            else rezultat = 1;
        }
    }

    *koren = t;
    return rezultat;
}


void ispisi(Cvor *koren){
    if(koren == NULL) return;
    ispisi(koren->levi);
    printf("%d ",koren->broj);
    ispisi(koren->desni);
    return;
}

void sumaListova(Cvor *koren, int *suma){
    if(koren == NULL) return;
    if(koren->levi == NULL && koren->desni == NULL){
        *suma += koren->broj;
        // printf("u sumu je uso %d\n",koren->broj);
        return;
    }
    sumaListova(koren->levi, suma);
    sumaListova(koren->desni, suma);

}

int main(){

    int broj;
    Cvor *koren = NULL;
    scanf("%d",&broj);
    while(broj){
        dodaj(&koren,broj);
        scanf("%d",&broj);
    }
    int *listoviSuma;
    *listoviSuma = 0;
    sumaListova(koren, listoviSuma);
    // ispisi(koren);
    printf("%d\n",*listoviSuma);
    return 0;
}