#include<stdio.h>
#include<stdlib.h>

typedef struct element{
    int broj;
    struct element *l, *d;
}Element;

void dodaj(Element **koren, int x)
{
    if(!*koren)
    {
        Element *novi = (Element *)malloc(sizeof(Element));
        novi->broj = x;
        novi->l = novi->d = NULL;
        *koren = novi;
    }else if(x<(*koren)->broj)
    {
        dodaj(&(*koren)->l, x);
    }
    else
    {
        dodaj(&(*koren)->d, x);
    }
}
void ispis(Element *koren)
{
    if(!koren)
    {
        return;
    }
    printf("%d", koren->broj);
    ispis(koren->l);
    ispis(koren->d);
}
void razmak(char c, int n)
{
    while(n--)
    {
        putchar(c);
    }
}
void vizuelniPrikaz(Element *koren, int nivo)
{
    if(!koren)
    {   
        razmak('~', nivo);
    }
    else
    {
        vizuelniPrikaz(koren->d, nivo+1);
        razmak('~', nivo);
        printf("%d ", koren->broj);
        vizuelniPrikaz(koren->l, nivo+1);
    }
}
int transform(Element **koren)
{
    if(!*koren)
    {
        return 0;
    }
    Element *temp = *koren;
    int suma = 0;
    transform(&temp->l);
    transform(&temp->d);
    if(temp->l)
    {
        suma += temp->l->broj;
    }
    return suma;
}

int main()
{
    int n;
    scanf("%d ", &n);
    Element *koren = NULL;
    for(int i=0;i<n;i++)
    {
        int x;
        scanf("%d ", &x);
        dodaj(&koren, x);
    }
}
