#include <stdio.h>
#include <stdlib.h>

typedef struct cvor{
    int broj;
    struct cvor *levi, *desni;
}cvor;

void razmak(int n){
    for(int i = 0; i < n; i++) putchar('\t');
}
void vizuelniPrikaz(cvor *koren, int n){
    if(!koren){
        razmak(n);
        puts("~");
    }
    else{
        vizuelniPrikaz(koren->desni, n+1);
        razmak(n);
        printf("%d",koren->broj);
        vizuelniPrikaz(koren->levi, n+1);
    }
}

cvor *noviCvor(int x){
    cvor *koren = (cvor *)malloc(sizeof(cvor));
    koren->broj = x;
    koren->levi = koren->desni = NULL;

    return koren;
}


int dodaj(cvor **koren, int x){
    if(!*koren){
        *koren = noviCvor(x);
        return 1;
    }

    if((*koren)->broj > x) dodaj(&(*koren)->levi, x);
    else dodaj(&(*koren)->desni, x);

    return 1;
}

cvor *unos(){
    int n;
    scanf("%d",&n);

    cvor *koren = NULL;
    for(int i = 0; i < n; i++){
        int x;
        scanf("%d", &x);
        dodaj(&koren, x);
    }

    return koren;
}
int stampaj(cvor *koren){

    if(!koren) return 1;

    printf("%d\n", koren->broj);
    stampaj(koren->levi);
    stampaj(koren->desni);

    return 1;
}
int brojJednakih(cvor *koren, int x){
    if(!koren) return 0;

    if(koren->broj == x) return 1 + brojJednakih(koren->levi, x) + brojJednakih(koren->desni, x);
    return brojJednakih(koren->levi, x) + brojJednakih(koren->desni, x);
}
int transform(cvor **koren, int suma, cvor *root){

    if(!*koren) return suma;

    int pom,jednaki;
    jednaki = brojJednakih(root, (*koren)->broj) - 1;
    int jednakihIspod = brojJednakih((*koren)->desni, (*koren)->broj) + brojJednakih((*koren)->levi, (*koren)->broj);
    
    suma = transform(&(*koren)->levi, suma, root);
    pom = (*koren)->broj;

    (*koren)->broj = suma - (jednaki * (*koren)->broj) + (jednakihIspod * (*koren)->broj);

    suma += pom;

    suma = transform(&(*koren)->desni, suma, root);

    return suma;
}


int main(){

    cvor *koren;
    koren = unos();

    vizuelniPrikaz(koren,0);
    stampaj(koren);

    transform(&koren, 0, koren);
    printf("================\n");
    vizuelniPrikaz(koren,0);
    stampaj(koren);
    return 1;
}