#include <stdio.h>
#include <stdlib.h>


typedef struct cvor{
    int broj;
    int balans;
    struct cvor *levi, *desni;
}cvor;

cvor *noviCvor(int x){
    cvor *koren = (cvor *)malloc(sizeof(cvor));
    koren->broj = x;
    koren->balans = 0;
    koren->levi = koren->desni = NULL;

    return koren;
}
void razmak(int n){
    for(int i = 0; i < n; i++) putchar('\t');
}
void vizuelniPrikaz(cvor *koren, int n){

    if(!koren){
        razmak(n);
        puts("~");
    }
    else{
        vizuelniPrikaz(koren->desni, n+1);
        razmak(n);
        printf("%d",koren->broj);
        vizuelniPrikaz(koren->levi, n+1);
    }
}
int maks(int x, int y){
    if(x>y) return x;
    return y;
}

int dubina(cvor *koren){
    if(!koren) return 0;

    return 1 + maks(dubina(koren->levi),dubina(koren->desni));
}
void lRotacija(cvor **koren){
    cvor *pom1 = *koren;
    cvor *pom2 = pom1->desni;

    pom1->desni = pom2->levi;
    pom2->levi = pom1;
    *koren = pom2;

    pom1->balans = dubina(pom1->desni) - dubina(pom1->levi);
    pom2->balans = dubina(pom2->desni) - dubina(pom2->levi);
}

void dRotacija(cvor **koren){
    cvor *pom1 = *koren;
    cvor *pom2 = pom1->levi;

    pom1->levi = pom2->desni;
    pom2->desni = pom1;
    *koren = pom2;

    pom1->balans = dubina(pom1->desni) - dubina(pom1->levi);
    pom2->balans = dubina(pom2->desni) - dubina(pom2->levi);
}

int dodaj(cvor **koren, int x){
    cvor *t = *koren;

    if(!t){
        t = noviCvor(x);
        *koren = t;
        return 1;
    }

    int inc;
    if(t->broj < x) inc = dodaj(&t->desni, x);
    else inc = -dodaj(&t->levi, x);

    t->balans += inc;

    if(inc && t->balans){
        if(t->balans > 1){
            if(t->desni->balans > 0) lRotacija(&t);
            else{
                dRotacija(&t->desni);
                lRotacija(&t);
            }
        }
        else if(t->balans < -1){
            if(t->levi->balans < 0) dRotacija(&t);
            else{
                lRotacija(&t->levi);
                dRotacija(&t);
            }
        }
        else return 1;
    }

    *koren = t;
    return 0;
}
cvor *unos(){
    int x;
    cvor *koren = NULL;
    scanf("%d", &x);
    while(x){
        dodaj(&koren, x);
        scanf("%d",&x);
    }

    return koren;
}

int suma(cvor *koren, int db, int s){
    if(!koren) return s;

    printf("dubina - %d, broj - %d\n", db, koren->broj);
    if(db == 1){
        return s + koren->broj;
    }

    s = suma(koren->levi, db - 1, s);
    s = suma(koren->desni, db - 1, s);

    return s;
}


int main(){
    cvor *koren;

    koren = unos();

    vizuelniPrikaz(koren,0);

    printf("%d", dubina(koren));
    int s = suma(koren,dubina(koren),0);
    printf("%d\n", s);
}

