#include <stdio.h>
#include <stdlib.h>

typedef struct node
{
    int data;
    struct node *left, *right;
}Node;

void printInorder(Node *root);

void printPreorder(Node *root);

Node *addToTree(Node *root, int data);

Node *transform(Node *root, int *sum);

int main()
{
    int n, i;
    scanf("%d", &n);

    Node *root = NULL;
    for(i = 0; i < n; i++)
    {
        int data;
        scanf("%d", &data);

        root = addToTree(root, data);
    }

    //printInorder(root);

    int sum = 0;
    root = transform(root, &sum);

    printPreorder(root);

    return 0;
}

Node *addToTree(Node *root, int data)
{
    if(root == NULL)
    {
        Node *newNode = (Node*)malloc(sizeof(Node));
        if(newNode == NULL)
        {
            printf("MALLOC ERROR\n");
            exit(1);
        }

        newNode->data = data;
        newNode->left = newNode->right = NULL;

        root = newNode;
    }
    else
    {
        if(data >= root->data)
            root->right = addToTree(root->right, data);
        else
            root->left = addToTree(root->left, data);
    }

    return root;
}

void printInorder(Node *root)
{
    if(root == NULL)
        return;
    printInorder(root->left);
    printf("%d\n", root->data);
    printInorder(root->right);
}


void printPreorder(Node *root)
{
    if(root == NULL)
        return;
    
    printf("%d\n", root->data);
    printPreorder(root->left);
    printPreorder(root->right);
}

Node *transform(Node *root, int *sum)
{
    if(root == NULL)
        return NULL;

    root->left = transform(root->left, sum);
    
    int temp = root->data;
    root->data = *sum;
    *sum += temp;

    root->right = transform(root->right, sum);
    
    return root;
}