#include <stdio.h>
#include <stdlib.h>

typedef struct node
{
    int data, balance;
    struct node *left, *right;
}Node;

void printInorder(Node *root);

int addToTree(Node **root, int data);

void leftRotate(Node **root);

void rightRotate(Node **root);

int getDepth(Node *root);

int digitSum(int data);

int leafSum(Node *root);

void padding(char ch, int n);

void printTreeGraphic(Node *root, int level);

int main()
{
    int data;
    scanf("%d", &data);

    Node *root = NULL;
    while(data != 0)
    {
        addToTree(&root, data);
        scanf("%d", &data);
    }

    //printf("Inorder \n");
    //printInorder(root);

    printf("%d\n", leafSum(root));

    //printTreeGraphic(root, 0);

    //printf("Balance %d\n", getDepth(root->right) - getDepth(root->left));

    return 0;
}

void printInorder(Node *root)
{
    if(root == NULL)
        return;
    printInorder(root->left);
    printf("%d\n", root->data);
    printInorder(root->right);
}

int addToTree(Node **root, int data)
{
    int increment, result = 0;
    if(*root == NULL)
    {
        Node *newNode = (Node*)malloc(sizeof(Node));
        newNode->data = data;

        newNode->balance = 0;
        newNode->left = newNode->right = NULL;

        *root = newNode;
        result = 1;
    }
    else
    {
        if(digitSum(data) >= digitSum((*root)->data))
            increment = addToTree(&(*root)->right, data);
        else
            increment = -addToTree(&(*root)->left, data);

        (*root)->balance += increment;

        if((*root)->balance != 0 && increment != 0)
        {
            if((*root)->balance > 1)
            {
                if((*root)->right->balance > 0)
                    leftRotate(root);
                else
                {
                    rightRotate(&(*root)->right);
                    leftRotate(root);
                }
            }
            else if((*root)->balance < -1)
            {
                if((*root)->left->balance < 0)
                    rightRotate(root);
                else
                {
                    leftRotate(&(*root)->left);
                    rightRotate(root);
                }
            }
            else
                result = 1;
        }
    }

    return result;
}


void leftRotate(Node **root)
{
    Node *tempLeft, *tempRight;

    tempLeft = *root;
    tempRight = tempLeft->right;
    tempLeft->right = tempRight->left;
    tempRight->left = tempLeft;

    *root = tempRight;

    tempLeft->balance = getDepth(tempLeft->right) - getDepth(tempLeft->left);
    tempRight->balance = getDepth(tempRight->right) - getDepth(tempRight->left);
}

void rightRotate(Node **root)
{
    Node *tempLeft, *tempRight;

    tempRight = *root;
    tempLeft = tempRight->left;
    tempRight->left = tempLeft->right;
    tempLeft->right = tempRight;

    *root = tempLeft;

    tempLeft->balance = getDepth(tempLeft->right) - getDepth(tempLeft->left);
    tempRight->balance = getDepth(tempRight->right) - getDepth(tempRight->left);
}


int getDepth(Node *root)
{
    if(root == NULL)
        return 0;

    int leftDepth = getDepth(root->left);
    int rightDepth = getDepth(root->right);

    return 1 + (leftDepth > rightDepth ? leftDepth : rightDepth);
}

int digitSum(int data)
{
    if(data == 0)
        return 0;
    
    int sum = (data % 10);

    return sum + digitSum(data / 10);
}

int leafSum(Node *root)
{
    if(root == NULL)
        return 0;

    int leftSum = leafSum(root->left);
    int rightSum = leafSum(root->right);

    int sum = leftSum + rightSum;

    if(root->left == NULL && root->right == NULL)
    {
        //printf("List %d\n", root->data);
        sum += root->data;
    }

    return sum;
}


void padding(char ch, int n)
{
    int i;
    for(i = 0; i < n; i++)
        putchar(ch);
}

void printTreeGraphic(Node *root, int level)
{
    if(root == NULL)
    {
        padding('\t', level);
        puts("~");
    }
    else
    {
        printTreeGraphic(root->right, level + 1);
        padding('\t', level);
        printf("%d", root->data);
        printTreeGraphic(root->left, level + 1);
        puts("\n");
    }

}