#include<stdio.h>
#include<stdlib.h>

typedef struct cvor{
	int broj;
	int balans;
	struct cvor *levi,*desni;
}Cvor;

int max(int x,int y)
{
	return (x<y)?y:x;
}

int dubina(Cvor *p)
{
	if(p==NULL) return 0;
	return 1+max(dubina(p->levi),dubina(p->desni));
}

void levaRotacija(Cvor **t)
{
	Cvor *poml,*pomd;
	poml=*t;
	pomd=poml->desni;
	poml->desni=pomd->levi;
	pomd->levi=poml;
	*t=pomd;
	
	poml->balans=dubina(poml->desni)-dubina(poml->levi);
	pomd->balans=dubina(pomd->desni)-dubina(pomd->levi);
}

void desnaRotacija(Cvor **t)
{
	Cvor *poml,*pomd;
	pomd=*t;
	poml=pomd->levi;
	pomd->levi=poml->desni;
	poml->desni=pomd;
	*t=poml;
	
	poml->balans=dubina(poml->desni)-dubina(poml->levi);
	pomd->balans=dubina(pomd->desni)-dubina(pomd->levi);
}

int zbirCifara(int broj)
{
	if(broj<10) return broj;
	int zbir=0;
	int x=broj%10;
	while(x)
	{
		zbir+=x;
		broj=broj/10;
		x=broj%10;
	}
	return zbir;
}

int dodaj(Cvor **p,int br)
{
	int rez=0,inkrement;
	Cvor *pom=*p;
	if(pom==NULL)
	{
		pom=(Cvor*)malloc(sizeof(Cvor));
		pom->broj=br;
		pom->balans=0;
		pom->levi=pom->desni=NULL;
		rez=1;
	}
	else
	{
		if(zbirCifara(br)<zbirCifara(pom->broj))
		{
			inkrement=-dodaj(&(pom->levi),br);
		}
		else
		{
			inkrement=dodaj(&(pom->desni),br);
		}
		pom->balans+=inkrement;
		if(pom->balans!=0 && inkrement!=0)
		{
			if(pom->balans<-1)
			{
				if(pom->levi->balans<0)
				{
					desnaRotacija(&pom);
				}
				else
				{
					levaRotacija(&(pom->levi));
					desnaRotacija(&pom);
				}
			}
			else if(pom->balans>1)
			{
				if(pom->desni->balans>0)
				{
					levaRotacija(&pom);
				}
				else
				{
					desnaRotacija(&(pom->desni));
					levaRotacija(&pom);
				}
			}
			else rez=1;
		}
	}
	*p=pom;
	return rez;
}

void razmak(char c,int n)
{
	while(n--) putchar(c);
}

void ispis(Cvor *p,int nivo)
{
	if(!p)
	{
		razmak('\t',nivo);
		puts("~");
	}
	else
	{
		ispis(p->desni,nivo+1);
		razmak('\t',nivo);
		printf("%d\n",p->broj);
		ispis(p->levi,nivo+1);
	}
}

void sredi(Cvor **p)
{
	Cvor *pom=*p;
	if(pom)
	{
		if(pom->balans<-1)
			{
				if(pom->levi->balans<0)
				{
					desnaRotacija(&pom);
				}
				else
				{
					levaRotacija(&(pom->levi));
					desnaRotacija(&pom);
				}
			}
			else if(pom->balans>1)
			{
				if(pom->desni->balans>0)
				{
					levaRotacija(&pom);
				}
				else
				{
					desnaRotacija(&(pom->desni));
					levaRotacija(&pom);
				}
			}
	}
	*p=pom;
}

Cvor *formiraj()
{
	Cvor *p=NULL;
	int br;
	scanf("%d",&br);
	while(br)
	{
		dodaj(&p,br);
		scanf("%d",&br);
	}
	return p;
}

void zbirPoslednjiNivo(Cvor *p,int *suma,int poslednjiNivo,int trenutniNivo)
{
	if(p==NULL) return;
	if(poslednjiNivo==trenutniNivo && p->levi==NULL && p->desni==NULL)
	{
		(*suma)+=p->broj;
	}
	zbirPoslednjiNivo(p->levi,suma,poslednjiNivo,trenutniNivo+1);
	zbirPoslednjiNivo(p->desni,suma,poslednjiNivo,trenutniNivo+1);
}


int main()
{
	Cvor *p=formiraj();
	//ispis(p,0);
	printf("\n-----------------\n");
	
	int poslNivo=dubina(p);
	int suma=0;
	zbirPoslednjiNivo(p,&suma,poslNivo,1);
	printf("\n%d\n",suma);
	return 0;
}
