#include <stdio.h>
#include <stdlib.h>

typedef struct cvor
{
	int broj;
	int balans;
	struct cvor *levi,*desni;
}Cvor;

Cvor *kreirajCvor(int broj)
{
	Cvor *pom;
	pom = (Cvor*)malloc(sizeof(Cvor));
	pom->broj=broj;
	pom->levi=pom->desni=NULL;
	return pom;

}
int zbirCifara(int broj)
{
	int zbir=0;
	int cifra;
	while(broj!=0)
	{
		cifra=broj%10;
		zbir+=cifra;
		broj=broj/10;
	}
	return zbir;
}
int dubinaStabla(struct cvor *koren)
{
	int dubinaLevi,dubinaDesni;
	
	dubinaLevi = dubinaStabla(koren->levi);
	dubinaDesni = dubinaStabla(koren->desni);
	
	return (dubinaLevi>dubinaDesni?dubinaLevi:dubinaDesni);
}


void levaRotacija(Cvor **koren)
{
	Cvor *pomL,*pomD;
	pomL = *koren;
	pomD = pomL->desni;
	pomL->desni = pomD->levi;
	pomD->levi = pomL;
	pomD = *koren;
	
	pomL->balans = dubinaStabla(pomL->desni) - dubinaStabla(pomL->levi);
	pomD->balans = dubinaStabla(pomL->desni) - dubinaStabla(pomL->levi);
	 
}


void desnaRotacija(Cvor **koren)
{
	Cvor *pomL,*pomD;
	pomD = *koren;
	pomL = pomD->levi;
	pomD->levi = pomL->desni;
	pomL->desni = pomD;
	pomL = *koren;
	
	pomL->balans = dubinaStabla(pomL->desni) - dubinaStabla(pomL->levi);
	pomD->balans = dubinaStabla(pomL->desni) - dubinaStabla(pomL->levi);
}
int dodajCvor(struct cvor **koren,int broj)
{
	if(!(*koren))
	{
		*koren = kreirajCvor(broj);
		return 0;
	}
	Cvor *pomCvor=*koren;
	int inkrement=0,rezultat=0;
	if(zbirCifara(broj)<(zbirCifara(pomCvor->broj)))
	    inkrement = -dodajCvor(koren,broj);
	 else
	    inkrement = dodajCvor(koren,broj);
  
    pomCvor->balans+=inkrement;
    
    if(pomCvor->balans!=0 && inkrement!=0)
    {
		if(pomCvor->balans>1)
		{
			levaRotacija(&pomCvor);
			if(pomCvor->balans>0)
			{
				desnaRotacija(&(pomCvor->desni));
				levaRotacija(&pomCvor);
			}
		}
		else if(pomCvor->balans<-1)
		{
			desnaRotacija(&pomCvor);
			if(pomCvor->balans<0)
		     {
				 levaRotacija(&(pomCvor->levi));
				 desnaRotacija(&pomCvor);
			 }
		}
		else
		rezultat = 1;
	} 	       
 	*koren = pomCvor;
	return rezultat;
}
void formirajStablo(struct cvor *koren)
{
	int unetBroj;
	scanf("%d",&unetBroj);
	while(unetBroj!=0)
	{
		dodajCvor(&koren,unetBroj);
		scanf("%d",&unetBroj);
	}
}
void stampaj(struct cvor *koren)
{
	stampaj(koren->levi);
	printf("%d",koren->broj);
	stampaj(koren->desni);
}
int sumaListova(struct cvor *koren)
{
	int suma=0;
	int sumaLevi=0;
	int sumaDesni=0;
	sumaLevi += sumaListova(koren->levi);
	sumaDesni += sumaListova(koren->desni);
	
	sumaLevi+=koren->broj;
	sumaDesni+=koren->broj;
	
	suma = sumaLevi+sumaDesni;
	return suma;
	
}
int main()

{
	Cvor *koren = NULL;
	int suma;
	formirajStablo(koren);
	stampaj(koren);
	suma = sumaListova(koren);
	printf("%d",suma);
}
