#include<stdio.h>
#include<stdlib.h>

typedef struct cvor{
    int balans;
    int broj;
    struct cvor *levi,*desni;
}Cvor;

int max(int a, int b){
    return a>b? a : b;
}

int dubina(Cvor *cvor){
    if(!cvor) return 0;
    else return max(dubina(cvor->levi), dubina(cvor->desni));
}

void lrotacija(Cvor **koren){
    Cvor* pomlevi = *koren;
    Cvor* pomdesni = pomlevi->desni;
    pomlevi->desni = pomdesni->levi;
    pomdesni->levi = pomlevi;
    *koren = pomdesni;

    pomdesni->balans = dubina(pomdesni)-dubina(pomlevi);
    pomlevi->balans = dubina(pomdesni)-dubina(pomlevi);
}

void drotacija(Cvor **koren){
    Cvor* pomdesni = *koren;
    Cvor* pomlevi = pomdesni->levi;
    pomdesni->levi= pomlevi->desni;
    pomlevi->desni = pomdesni;
    *koren = pomlevi;

    pomdesni->balans = dubina(pomdesni)-dubina(pomlevi);
    pomlevi->balans = dubina(pomdesni)-dubina(pomlevi);
}

Cvor *novi(int x){
    
    Cvor *novi = (Cvor*)malloc(sizeof(Cvor));
    novi->broj = x;
    novi->levi = novi->desni = NULL;
    
    return novi;
}

int zbirCifara(int x){
    int suma=0;
    while(x>0){
        suma += x%10;
        x=x/10;
    }
    return suma;
}

int dodaj(Cvor **koren, int x){

    Cvor *t = *koren;

    if(t == NULL){
        t = novi(x);
        *koren = t;
        return 1;
    }

    int inc;
  
    if(zbirCifara(x)>zbirCifara(t->broj))
        inc = dodaj(&(t->desni),  x);
    else
        inc = -dodaj(&(t->levi), x);

    t->balans += inc;

    if(inc && t->balans){
        if(t->balans<-1){
            if(t->levi->balans<0)
                drotacija(&t);
            else{
                lrotacija(&(t->levi));
                drotacija(&t);
            }
        }
        else if(t->balans > 1){
            if(t->desni->balans > 0)
                lrotacija(&t);
            else{
                drotacija(&(t->desni));
                lrotacija(&t);
            }
    }
        else return 1;
    }

    *koren = t;
    return 0;

}


void stampaj(Cvor *koren){
    if(koren){
        stampaj(koren->levi);
        printf("%d ", koren->broj);
         stampaj(koren->desni);
    }
}
int zbirListova(Cvor *t){
  if(!t) return 0;
  else{
    if(t->levi==NULL && t->desni==NULL)
        return t->broj;
    else 
        return  zbirListova(t->levi) + zbirListova(t->desni);
  }
}

int main(){

    Cvor *koren=NULL;
    int c=1, suma;
    scanf("%d", &c);
    while(c!=0){
          dodaj(&koren, c);
           scanf("%d", &c);
    }
  
  // stampaj(koren);
   printf("%d ", zbirListova(koren));
}