#include <stdio.h>
#include <stdlib.h>


typedef struct stablo{
    int broj;
    int balans;
    struct stablo *levo, *desno;
}Stablo;

Stablo *alociraj(int br){
    Stablo *novi = (Stablo*)malloc(sizeof(Stablo));

    novi -> broj = br;
    novi -> balans = 0;
    novi -> levo = novi -> desno = NULL;

    return novi;
}

int dubina(Stablo *root){

    if(!root){
        return 0;
    }

    int levaDubina = dubina(root->levo);
    int desnaDubina = dubina(root->desno);

    return 1 + (levaDubina > desnaDubina ? levaDubina : desnaDubina);
}


void levarotacija(Stablo **root){
    Stablo *poml = *root;
    Stablo *pomd = poml -> desno;

    poml -> desno = pomd -> levo;
    pomd -> levo = poml;
    *root = pomd;

    poml -> balans = dubina(poml -> desno) - dubina(poml -> levo);
    pomd -> balans = dubina(pomd -> desno) - dubina(pomd -> levo);
}

void desnarotacija(Stablo **root){
    Stablo *pomd = *root;
    Stablo *poml = pomd -> levo;

    pomd -> levo = poml -> desno;
    poml -> desno = pomd;
    *root = poml;

    poml -> balans = dubina(poml -> desno) - dubina(poml -> levo);
    pomd -> balans = dubina(pomd -> desno) - dubina(pomd -> levo);
}


int dodaj(Stablo **root, int br){
    if(!(*root)){
        *root = alociraj(br);
        return 1;
    }

    int inkrement = 0;
    int result = 0;
    Stablo *pom = *root;

    if(br < (*root)->broj){
        inkrement = -dodaj(&(*root)->levo, br);
    }
    else inkrement = dodaj(&(*root)->desno, br);

    pom -> balans += inkrement;

    if(pom->balans != 0 && inkrement != 0){
        if(pom->balans > 1){
            if(pom->desno->balans > 0){
                levarotacija(&pom);
            }
            else{
                desnarotacija(&(pom->desno));
                levarotacija(&pom);
            }
        }
        else if(pom->balans < -1){
            if(pom->levo->balans < 0){
                desnarotacija(&pom);
            }
            else{
                levarotacija((&pom->levo));
                desnarotacija(&pom);
            }
        }
        else result = 1;

    }

    *root = pom;
    return result;
    


}

void sumiraj(Stablo *root, int *suma, int level, int nivo){//treba malo da se izmeni ne sabira lepo

    if(!root)return;

    sumiraj(root->levo, suma, level + 1, nivo);
    
    if(level == nivo){
        *suma += root->broj;
    }

    sumiraj(root->desno, suma, level + 1, nivo);

}

void ispis(Stablo *root){
    if(!root)return;
    
    printf("%d\n",root->broj);
    
    ispis(root->levo);
    ispis(root->desno);

}

int main(){

    Stablo *root = NULL;

    int n;
    while(1){
        scanf("%d", &n);
        if(n == 0){
            break;
        }
        dodaj(&root, n);
    }

    int zadnjinivo = dubina(root) - 1;
    //printf("%d", zadnjinivo);
    int suma = 0;
    int level = 0;
    
    printf("\n");
    //ispis(root);

    sumiraj(root, &suma, level, zadnjinivo);
    printf("Suma poslednjeg nivoa: %d\n", suma);
}