#include <stdio.h>
#include <stdlib.h>

typedef struct node{
    int number;
    int sum;
    int balance;
    struct node *left, *right;
}NODE;

#define NEW_NODE() (NODE*) malloc (sizeof(NODE))

void alloc_error(){
    printf("Allocation Error\n");
    exit(1);
}

int get_sum(int x){
    int sum = 0;
    while (x > 0){
        sum += x%10;
        x = x/10;
    }
    return sum;
}

int max(int a, int b){
    return a > b ? a : b;
}

int depth(NODE *root){
    if (!root) return 0;
    return 1 + max(depth(root->left), depth(root->right));
}

int new_balance(NODE *root){
    return depth(root->right) - depth(root->left);
}

void left_rotation(NODE **root){
    NODE *a = *root;
    NODE *b = a->right;

    a->right = b->left;
    b->left = a;
    *root = b;

    a->balance = new_balance(a);
    b->balance = new_balance(b);
}

void right_rotation(NODE **root){
    NODE *a = *root;
    NODE *b = a->left;

    a->left = b->right;
    b->right = a;
    *root = b;

    a->balance = new_balance(a);
    b->balance = new_balance(b);
}

int compare(int sum, NODE *root){
    if (sum > root->sum) return 1;
    if (sum < root->sum) return -1;
    return 0;
}

int insert(NODE **root, NODE *new){
    if (!*root){
        *root = new;
        return 1;
    }

    int inc, result = 0;
    NODE *temp = *root;

    if (compare(new->sum, *root) >= 0) inc = insert(&temp->right, new);
    else inc = -insert(&temp->left, new);
    
    temp->balance += inc;

    if (temp->balance != 0 && inc != 0){
        if (temp->balance > 1){
            if (temp->right && temp->right->balance > 0){
                left_rotation(&temp);
            }
            else{
                right_rotation(&temp->right);
                left_rotation(&temp);
            }
        }
        else if (temp->balance < -1){
            if (temp->left && temp->left->balance < 0){
                right_rotation(&temp);
            }
            else{
                left_rotation(&temp->left);
                right_rotation(&temp);
            }
        }
        else result = 1;
    }
    
    *root = temp;
    return result;
}

NODE *create_node(int x){
    NODE *new = NEW_NODE();
    if (!new) alloc_error();
    new->number = x;
    new->sum = get_sum(x);
    new->balance = 0;
    new->left = new->right = NULL;
    return new;
}

void create_tree(NODE **root){
    int x;
    scanf("%d", &x);
    while (x != 0){
        NODE *new = create_node(x);
        insert(root, new);
        scanf("%d", &x);
    }
}

void max_d(NODE *root, int current_depth, int *max_depth){
    if (!root) return;

    max_d(root->right, current_depth+1, max_depth);
    max_d(root->left, current_depth+1, max_depth);

    if (current_depth > *max_depth) *max_depth = current_depth;
}

void all_sum(NODE *root, int current_depth, int max_depth, int *sum){
    if (!root) return;

    if (current_depth == max_depth) (*sum) += root->number;

    all_sum(root->right, current_depth+1, max_depth, sum);
    all_sum(root->left, current_depth+1, max_depth, sum);
}

int main(){
    NODE *root=NULL;
    create_tree(&root);

    int max_depth = 0;
    max_d(root, 0, &max_depth);

    int sum=0;
    all_sum(root, 0, max_depth, &sum);
    printf("%d\n", sum);
}