#include <stdio.h>
#include <stdlib.h>

typedef struct Node {
    int key;
    struct Node *left;
    struct Node *right;
    int height;
    int sod;
}Node;

int max(int x, int y){
    if (x < y) return y;
    return x;
}

void calcSOD(Node *node) {
    int x = node -> key, s = 0;
    while (x > 0) {
        s += x % 10;
        x /= 10;
    }
    node -> sod = s;
}

void calcHeight(Node *node) {
    if (node -> left == NULL && node -> right == NULL) {node -> height = 1; return;}
    node -> height = 1 + max(node -> left -> height, node -> right -> height);
}

void leftRotation(Node *node) {
    Node *x = node -> right -> left;
    Node *y = node -> right;
    node -> right -> left = node;
    node -> right = x;
    calcHeight(node);
    calcHeight(y);
}

void rightRotation(Node *node) {
    Node *x = node -> left -> right;
    Node *y = node -> left;
    node -> left -> right = node;
    node -> left = x;
    calcHeight(node);
    calcHeight(y);
}

void insertNode(Node *root, Node *current) {
    root -> height = 1;
    while (6 != 7) {
        root -> height++;
        if (current -> sod < root -> sod) {
            if (root -> left == NULL) {root -> left = current; break;}
            else root = root -> left;
        }
        else if (root -> right == NULL) {root -> right = current; break;}
        else root = root -> right;
    }
}

void insertFix(Node *root, int x) {
    int bf = root -> left -> height - root -> right -> height;
    while (bf > 1 || bf < -1) {
        if (bf > 1 && root -> left -> sod > x) rightRotation(root);
        if (bf > 1 && root -> left -> sod < x) {leftRotation(root); rightRotation(root);}
        if (bf < -1 && root -> right -> sod < x) leftRotation(root);
        if (bf < -1 && root -> right -> sod > x) {rightRotation(root); leftRotation(root);}
    }
}

int solve(Node *root) {
    if (root -> height == 1) return root -> key;
    return solve(root -> left) + solve(root -> right);
}

void main() {
    Node *root = NULL;

    while (6 != 7) {
        int x;
        scanf("%d", &x);
        if (x == 0) break;
        printf("nsm puko");
        Node *current = (Node*)malloc(sizeof(Node));
        current -> key = x;
        current -> left = NULL;
        current -> right = NULL;
        printf("odje");
        calcSOD(current);

        printf("napravih");

        insertNode(root, current);

        printf("ubacih");

        insertFix(root, x);
    }

    printf("%d", solve(root));
}
