#include <stdio.h>
#include <stdlib.h>

typedef struct cvor{
    int vrednost;
    struct cvor *l,*d;
    int balans;
}cvor;

cvor *noviCvor(int vrednost)
{
    cvor *novi=(cvor *)malloc(sizeof(cvor));
    novi->vrednost=vrednost;
    novi->l=novi->d=NULL;
    novi->balans=0;
    return novi;
}

int max(int a,int b)
{
    return a>b?a:b;
}

int dubina(cvor *koren)
{
    if(!koren) return 0;
        return 1+max(dubina(koren->l),dubina(koren->d));
}

int sumaCifara(int broj)
{
    int sumaCifara=0;
    while(broj/10>0){
        sumaCifara+=broj%10;
        broj=broj%10;
    }
    return sumaCifara;
}

void lRotacija(cvor **t)
{
    cvor *poml=t;
    cvor *pomd=poml->d;
    poml->d=pomd->l;
    pomd->l=poml;
    *t=pomd;

    poml->balans=dubina(poml->d)-dubina(poml->l);
    pomd->balans=dubina(pomd->d)-dubina(pomd->l);
}

void dRotacija(cvor **t)
{
    cvor *pomd=t;
    cvor *poml=pomd->l;
    pomd->l=poml->d;
    poml->d=pomd;
    *t=poml;

    poml->balans=dubina(poml->d)-dubina(poml->l);
    pomd->balans=dubina(pomd->d)-dubina(pomd->l);
}

cvor *dodaj(cvor **koren,int vrednost)
{
    if(!koren)
    {
        return koren;
    }

    cvor *t=koren;

    int sumaCif=sumaCifara(t->vrednost);

    int inc;
    if(sumaCif<sumaCifara(&koren->vrednost))
    {
        inc=dodaj(t->l,vrednost);
    }
    else{
        inc=dodaj(t->d,vrednost);
    }

    
    t->balans+=inc;

    if(inc && t->balans)
    {
        if(t->balans<0)
        {
            if(t->l->balans<-1){
                dRotacija(&t);
            }
            else{
                lRotacija(&t->l);
                dRotacija(&t);
            }
        }
        else if(t->balans>0){
            if(t->d->balans>1){
                lRotacija(&t);
            }
            else{
                dRotacija(&t->d);
                lRotacija(&t);
            }
        }
        else{
            *koren=t;
            return 1;
        }
    }
    *koren=t;
    return 1;
}

int maxDubina(cvor *koren)
{
    if(!koren) return 0;
    return 1+max(maxDubina(koren->l),maxDubina(koren->d));
}

int sumaNaDubini(cvor *koren,int trazenaDubina)
{
    int suma=0;
    int trenutnaDubina=0;
    if(trenutnaDubina==trazenaDubina)
    {
        if(koren->l->vrednost)
            suma+=koren->l->vrednost;
        if(koren->d->vrednost)
            suma+=koren->d->vrednost;
    }

    sumaNaDubini(koren->l,trazenaDubina+1);
    sumaNaDubini(koren->d,trazenaDubina+1);
    return suma;
}

int main()
{
    int n;
    scanf("%d",&n);

    cvor *koren=NULL;
    for(int i=0;i<n;i++)
    {
        int vrednost;
        scanf("%d",&vrednost);
        koren=dodaj(koren,vrednost);
    }

    int maksDubina=maxDubina(koren);
    int sumaNaMaxDubini=sumaNaDubini(koren,maxDubina);

    printf("%d",sumaNaMaxDubini);
}