#include<stdio.h>
#include<stdlib.h>

typedef struct cvor
{
    int broj;
    int balans;
    struct cvor *levi, *desni;
}CVOR;

#define novi(x) x=(CVOR*) malloc (sizeof(CVOR));

int max(int x, int y)
{
    return x>y;
}

int dubina(CVOR *koren)
{
    if(koren==NULL) return 0;

    return 1+max(dubina(koren->levi), dubina(koren->desni));
}

void lRotacija(CVOR **koren)
{
    CVOR *poml, *pomd;

    poml=*koren;
    pomd=poml->desni;
    poml->desni=pomd->levi;
    pomd->levi=poml;
    *koren=pomd;

    pomd->balans=dubina(pomd->desni)-dubina(pomd->levi);
    poml->balans=dubina(poml->desni)-dubina(poml->levi);
}

void dRotacija(CVOR **koren)
{
    CVOR *poml, *pomd;

    pomd=*koren;
    poml=pomd->levi;
    pomd->levi=poml->desni;
    poml->desni=pomd;
    *koren=poml;

    pomd->balans=dubina(pomd->desni)-dubina(pomd->levi);
    poml->balans=dubina(poml->desni)-dubina(poml->levi);
}

int sumaCifara(int k)
{
    int suma=0;

    while(k>0)
    {
        suma=suma+(k%10);
        k=k/10;
    }
    return suma;
}


int dodaj(CVOR **koren, int k)
{
    int inkrement, rezultat=0;

    CVOR *pom;
    pom=*koren;

    if(pom==NULL)
    {
        novi(pom);
        if(pom==NULL)
        {
            printf("greska pri alokaciji memorije\n");
            exit(0);
        }

        pom->broj=k;
        pom->levi=pom->desni=NULL;
        pom->balans=0;
        rezultat=1;
    }
    else
    {
        if(sumaCifara(pom->broj)<sumaCifara(k))
        {
            inkrement=dodaj(&(pom->desni), k);
        }
        else
        {
            inkrement=-dodaj(&(pom->levi),k);
        }
        pom->balans+=inkrement;
        if(inkrement!=0 && pom->balans!=0)
        {
            if(pom->balans<-1)
            {
                if(pom->levi->balans<0)
                {
                    dRotacija(&pom);
                }
                else
                {
                    lRotacija(&(pom->levi));
                    dRotacija(&pom);
                }
            }
            else if(pom->balans>1)
            {
                if(pom->desni->balans>0)
                {
                    lRotacija(&pom);
                }
                else
                {
                    dRotacija(&(pom->desni));
                    lRotacija(&pom);
                }
                
            }
            else rezultat=1;
        }
    }
    *koren=pom;
    return rezultat;
}

int suma(CVOR *koren, int nivo, int dubina)
{
    if(koren==NULL) return 0;

    if(koren->levi==NULL && koren->desni==NULL && nivo==dubina) return koren->broj;

    return suma(koren->levi, nivo+1, dubina) + suma(koren->desni, nivo+1, dubina);
}



CVOR *form()
{
    CVOR *koren;
    koren=NULL;
    int k;
    scanf("%d", &k);
    while(k)
    {
        dodaj(&koren, k);
        scanf("%d", &k);
    }
    return koren;
}


int main()
{
    CVOR *koren;
    koren=NULL;

    koren=form();

   

    int d=dubina(koren);
    

    int s=suma(koren, 1, d);

    printf("suma je %d\n", s);

    


    
    return 0;
}