#include <stdio.h>
#include <stdlib.h>

typedef struct element
{
    int broj;
    int visina;
    struct element *levi,*desni;

}element;


element *alociraj(int broj)
{
    element *novi = (element*)malloc(sizeof(element));
    novi->broj = broj;
    novi->levi = NULL;
    novi->desni = NULL;
    novi->visina = 1;
    return novi;
}


int max(int a,int b)
{
    if(a>b) return a;
    return b;
}

int visina(element *koren)
{
    if(koren == NULL) return 0;
    return koren->visina;
}

int balans(element *koren)
{
    if(koren == NULL) return 0;
    return visina(koren->levi) - visina(koren->desni);

}

element *levaRotacija(element *koren)
{
    element *pom1 = koren->desni;
    element *pom2 = pom1->levi;

    pom1->levi = koren;
    koren->desni = pom2;

    koren->visina = 1+max(visina(koren->levi),visina(koren->desni));
    pom1->visina = 1+max(visina(pom1->levi),visina(pom1->desni));
}

element *desnaRotacija(element *koren)
{
    element *pom1 = koren->levi;
    element *pom2 = pom1->desni;

    pom1->desni = koren;
    koren->levi = pom2;

    koren->visina = 1+max(visina(koren->levi),visina(koren->desni));
    pom1->visina = 1+max(visina(pom1->levi),visina(pom1->desni));
}


int zbirCifara(int broj)
{
    int suma = 0;
    while(broj!=0)
    {
        broj = broj %10;
        suma+=broj;
        broj = broj/10;
    }

    return suma;
}

element *dodaj(element *koren,int broj)
{
    if(koren == NULL) return alociraj(broj);

    if(koren->broj > zbirCifara(broj))
    {
        koren->levi = dodaj(koren->levi,broj);
    }
    else
    {
        koren->desni = dodaj(koren->desni,broj);
    }

    koren->visina = 1+max(visina(koren->levi),visina(koren->desni));
    int b = balans(koren);

    if(b>1 && koren->levi->broj > zbirCifara(broj))
    {
        return desnaRotacija(koren);
    }
    if(b<-1 && koren->desni->broj < zbirCifara(broj))
    {
        return levaRotacija(koren);
    }

    if(b>1 && koren->levi->broj < zbirCifara(broj))
    {
        koren->levi = levaRotacija(koren->levi);
        return desnaRotacija(koren);
    }

    if(b<-1 && koren->desni->broj > zbirCifara(broj))
    {
        koren->desni = desnaRotacija(koren->desni);
        return levaRotacija(koren);
    }
    return koren;
    
}

int sumaNaPoslednjem(element *koren, int nivo, int maxDubina)
{
    if(koren == NULL) return 0;

    int levi = sumaNaPoslednjem(koren->levi,nivo,maxDubina+1);
    int desni = sumaNaPoslednjem(koren->desni,nivo,maxDubina+1);

    if(nivo == maxDubina)
    {
        return koren->broj + levi + desni;
    }

    return levi+desni;
}
int main()
{


    element *koren = NULL;
    while(1)
    {
        int x;
        scanf("%d",&x);
        if(x==0)
        {
            break;
        }

        koren=dodaj(koren,x);
    }

    int max = sumaNaPoslednjem(koren,koren->visina,1);
    printf("%d\n",max);
    return 0;
}