#include <stdio.h>
#include <stdlib.h>

typedef struct cvor{
    int broj;
    struct cvor *levi, *desni;
}cvor;

cvor *alociraj(int broj){
    cvor *novi = (cvor*)malloc(sizeof(cvor));
    novi->levi = novi->desni = NULL;
    novi->broj = broj;
    return novi;
}

cvor *dodaj(cvor *koren, int broj){
    if(koren == NULL) return alociraj(broj);

    if(koren->broj > broj){
        koren->levi = dodaj(koren->levi, broj);

    }
    else{
        koren->desni = dodaj(koren->desni, broj);
    }

    return koren;
}

int transform(cvor **koren, int *suma){
    if((*koren) == NULL) return 0;

    int levi = transform(&(*koren)->levi, suma);

    int pomocna = *suma;
    
    (*suma) += (*koren)->broj;
    (*koren)->broj = pomocna;
    

    int desni = transform(&(*koren)->desni, suma);

    return levi + desni + (*koren)->broj;

}

void razmak(int n){
    for(int i = 0; i < n; i++){
        printf("    ");
    }
}

void vizuelniPrikaz(cvor *koren, int nivo){
    if(koren == NULL){
        razmak(nivo);
        printf("~\n");
    }

    else{
        vizuelniPrikaz(koren->desni, nivo+1);
        razmak(nivo);
        printf("%d\n", koren->broj);
        vizuelniPrikaz(koren->levi, nivo+1);
    }

}


// void PrikazTrazeni(cvor *koren, int nivo){
//     if(koren == NULL){
//         razmak(nivo);
//         printf("~\n");
//     }

//     else{
//         razmak(nivo);
//         printf("%d\n", koren->broj);
//         PrikazTrazeni(koren->levi, nivo+1);
//         razmak(nivo);
//         PrikazTrazeni(koren->desni, nivo+1);
//     }
// }

int main(){

    cvor *koren = NULL;
    
    int n;
    scanf("%d", &n);

    int broj;

    for(int i = 0; i < n; i++){
        scanf("%d", &broj);
        koren = dodaj(koren, broj);
    }

    vizuelniPrikaz(koren, 0);

    int *suma;
    *suma = 0;

    int transformisano = transform(&koren, suma);

    printf("\n\n");

    // PrikazTrazeni(koren, 0);
    vizuelniPrikaz(koren, 0);

    return 0;
}