#include <stdio.h>
#include <stdlib.h>

typedef struct cvor{
    int broj;
    int visina;
    struct cvor *levi, *desni;
}cvor;

cvor *alociraj(int broj){
    cvor *novi = (cvor*)malloc(sizeof(cvor));
    novi->visina = 1;
    novi->levi = novi->desni = NULL;
    novi->broj = broj;
    return novi;
}

int maks(int a, int b){
    if(a>b) return a;
    else return b;
}

int visina(cvor *koren){
    if(koren == NULL) return 0;
    return koren->visina;
}

int balanss(cvor *koren){
    if(koren == NULL) return 0;
    return visina(koren->levi) - visina(koren->desni);
}

cvor *levaRotacija(cvor *koren){
    cvor *pomocnaLevi = koren;
    cvor *pomocnaDesni = koren->desni;

    pomocnaLevi->desni = pomocnaDesni->levi;
    pomocnaDesni->levi = pomocnaLevi;

    pomocnaLevi->visina = 1 + maks(visina(pomocnaLevi->levi), visina(pomocnaLevi->desni));
    pomocnaDesni->visina = 1 + maks(visina(pomocnaDesni->levi), visina(pomocnaDesni->desni));

    return pomocnaDesni;
}

cvor *desnaRotacija(cvor *koren){
    cvor *pomocnaLevi = koren->levi;
    cvor *pomocnaDesni = koren;

    pomocnaDesni->levi = pomocnaLevi->desni;
    pomocnaLevi->desni = pomocnaDesni;

    pomocnaLevi->visina = 1 + maks(visina(pomocnaLevi->levi), visina(pomocnaLevi->desni));
    pomocnaDesni->visina = 1 + maks(visina(pomocnaDesni->levi), visina(pomocnaDesni->desni));

    return pomocnaLevi;
}

int sumaListova(cvor *koren, int nivo, int visina){
    if(koren == NULL) return 0;
    
    int levi = sumaListova(koren->levi, nivo + 1, visina);
    int desni = sumaListova(koren->desni, nivo+1, visina);

    if(nivo == visina){
        return koren->broj;
    }
    return levi + desni;
}

int zbirCifara(int broj){
    int zbir = 0;
    while(broj != 0){
        zbir += broj%10;
        broj = broj/10;
    }
    return zbir;
}

int poredjenje(cvor *koren, int broj){
    if(zbirCifara(koren->broj) > zbirCifara(broj)){
        return 1;
    }
    else{
        return -1;
    }
}

cvor *dodaj(cvor *koren, int broj){
    if(koren == NULL) return alociraj(broj);

    int provera= poredjenje(koren, broj);
    if(provera > 0){
        koren->levi = dodaj(koren->levi, broj);
    }
    else{
        //ukoliko su isti ide desno
        koren->desni = dodaj(koren->desni, broj);
    }

    koren->visina = 1 + maks(visina(koren->levi), visina(koren->desni));

    int balans = balanss(koren);

    //nagnut ulevo
    if(balans > 1){
        if(poredjenje(koren->levi, broj) > 0){
            return desnaRotacija(koren);
        }
        else{
            koren->levi = levaRotacija(koren->levi);
            return desnaRotacija(koren);
        }
    }
    
    //nagnut udesno
    if(balans < -1){
        if(poredjenje(koren->desni, broj) < 0){
            return levaRotacija(koren);
        }
        else{
            koren->desni = desnaRotacija(koren->desni);
            return levaRotacija(koren);
        }
    }


    return koren;
}

void razmak(int n){
    for(int i = 0; i < n; i++){
        printf("    ");
    }
}

void vizuelniPrikaz(cvor *koren, int nivo){
    if(koren == NULL){
        razmak(nivo);
        printf("~\n");
    }

    else{
        vizuelniPrikaz(koren->desni, nivo+1);
        razmak(nivo);
        printf("%d\n", koren->broj);
        vizuelniPrikaz(koren->levi, nivo+1);
    }
}

int main(){
    
    cvor *koren = NULL;
    int n;

    scanf("%d", &n);

    while(n!= 0){
        koren = dodaj(koren, n);
        scanf("%d", &n);
    }

    vizuelniPrikaz(koren, 0);

    printf("%d\n", sumaListova(koren, 1, visina(koren)));

}
